# sdl2 cmake project-config input for ./configure scripts

set(prefix "/gnu/store/s1zyzsi6ljq7c53s3v4kcv2rp64b237h-sdl2-2.0.14") 
set(exec_prefix "${prefix}")
set(libdir "${exec_prefix}/lib")
set(SDL2_PREFIX "/gnu/store/s1zyzsi6ljq7c53s3v4kcv2rp64b237h-sdl2-2.0.14")
set(SDL2_EXEC_PREFIX "/gnu/store/s1zyzsi6ljq7c53s3v4kcv2rp64b237h-sdl2-2.0.14")
set(SDL2_LIBDIR "${exec_prefix}/lib")
set(SDL2_INCLUDE_DIRS "${prefix}/include/SDL2")
set(SDL2_LIBRARIES "-L${SDL2_LIBDIR} -Wl,-rpath,${libdir} -Wl,--enable-new-dtags -lSDL2")
string(STRIP "${SDL2_LIBRARIES}" SDL2_LIBRARIES)

if(NOT TARGET SDL2::SDL2)
  # Remove -lSDL2 as that is handled by CMake, note the space at the end so it does not replace e.g. -lSDL2main
  # This may require "libdir" beeing set (from above)
  string(REPLACE "-lSDL2 " "" SDL2_EXTRA_LINK_FLAGS "-Wl,-rpath,${libdir} -Wl,--enable-new-dtags -lSDL2 ")
  string(STRIP "${SDL2_EXTRA_LINK_FLAGS}" SDL2_EXTRA_LINK_FLAGS)
  string(REPLACE "-lSDL2 " "" SDL2_EXTRA_LINK_FLAGS_STATIC " -Wl,--no-undefined -lm  -lasound -lm -ldl -lpthread -L/gnu/store/bkwhsqh07mwqlz3hycp8sh83pff03p68-pulseaudio-16.1/lib -lpulse-simple -pthread -lpulse -pthread  -lX11 -lXext -lXcursor -lXrandr -lXxf86vm -L/gnu/store/s7ggklsx7db78lr6m3wka69kkwk7fk20-libdrm-2.4.117/lib -ldrm -L/gnu/store/jl7hv8px9fa8034hnfw6vd4rf8dfz254-mesa-23.2.1/lib -lgbm -L/gnu/store/0gy2768c2kh947d3nvka0i96vb0nq405-libxkbcommon-1.6.0/lib -L/gnu/store/ascv3p6s2yb16g58nls096ny1mmfqg3s-wayland-1.22.0/lib -lwayland-egl -lwayland-client -lwayland-cursor -lxkbcommon -lpthread -lrt ")
  string(STRIP "${SDL2_EXTRA_LINK_FLAGS_STATIC}" SDL2_EXTRA_LINK_FLAGS_STATIC)

  add_library(SDL2::SDL2 SHARED IMPORTED)
  set_target_properties(SDL2::SDL2 PROPERTIES
    INTERFACE_INCLUDE_DIRECTORIES "${prefix}/include/SDL2"
    IMPORTED_LINK_INTERFACE_LANGUAGES "C"
    IMPORTED_LOCATION "${exec_prefix}/lib/${CMAKE_SHARED_LIBRARY_PREFIX}SDL2${CMAKE_SHARED_LIBRARY_SUFFIX}"
    INTERFACE_LINK_LIBRARIES "${SDL2_EXTRA_LINK_FLAGS}")

  add_library(SDL2::SDL2-static STATIC IMPORTED)
  set_target_properties(SDL2::SDL2-static PROPERTIES
    INTERFACE_INCLUDE_DIRECTORIES "${prefix}/include/SDL2"
    IMPORTED_LINK_INTERFACE_LANGUAGES "C"
    IMPORTED_LOCATION "${exec_prefix}/lib/${CMAKE_STATIC_LIBRARY_PREFIX}SDL2${CMAKE_STATIC_LIBRARY_SUFFIX}"
    INTERFACE_LINK_LIBRARIES "${SDL2_EXTRA_LINK_FLAGS_STATIC}")

  add_library(SDL2::SDL2main STATIC IMPORTED)
  set_target_properties(SDL2::SDL2main PROPERTIES
    IMPORTED_LINK_INTERFACE_LANGUAGES "C"
    IMPORTED_LOCATION "${exec_prefix}/lib/${CMAKE_STATIC_LIBRARY_PREFIX}SDL2main${CMAKE_STATIC_LIBRARY_SUFFIX}")
endif()
